/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.tooltip;

import dev.lambdaurora.spruceui.tooltip.components.ClientSpriteTooltipComponent;
import dev.lambdaurora.spruceui.tooltip.components.ClientTextTooltipComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5684;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6383;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record TooltipData(@Unmodifiable List<Entry> tooltip, @Nullable class_2960 style) implements class_6383
{
    public static final TooltipData EMPTY = new TooltipData(List.of(), null);

    public TooltipData(Entry ... entries) {
        this((class_2960)null, entries);
    }

    public TooltipData(@Nullable class_2960 style, Entry ... entries) {
        this(List.of(entries), style);
    }

    public boolean isEmpty() {
        return this.tooltip.isEmpty();
    }

    public void ifPresent(@NotNull Consumer<TooltipData> action) {
        if (!this.isEmpty()) {
            action.accept(this);
        }
    }

    @NotNull
    public Stream<class_2561> streamText() {
        return this.tooltip.stream().filter(TextEntry.class::isInstance).map(TextEntry.class::cast).map(TextEntry::text);
    }

    public void method_37020(@NotNull class_6382 builder) {
        this.streamText().forEach(text -> builder.method_37034(class_6381.field_33790, text));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static sealed interface Entry
    permits TextEntry, ComponentEntry {
        @NotNull
        public class_5684 toComponent();
    }

    public record TextEntry(@NotNull class_2561 text) implements Entry
    {
        @Override
        @NotNull
        public class_5684 toComponent() {
            return new ClientTextTooltipComponent(this.text.method_30937());
        }
    }

    public static class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();
        @Nullable
        private class_2960 style;

        public Builder text(String ... text) {
            return this.text(String.join((CharSequence)"\n", text));
        }

        public Builder text(@NotNull String text) {
            return this.text((class_2561)class_2561.method_43470((String)text));
        }

        public Builder text(class_2561 ... text) {
            class_5250 joiner = class_2561.method_43473();
            for (int i = 0; i < text.length; ++i) {
                joiner = joiner.method_10852(text[i]);
                if (i >= text.length - 1) continue;
                joiner = joiner.method_27693("\n");
            }
            return this.text((class_2561)joiner);
        }

        public Builder text(@NotNull class_2561 text) {
            this.entries.add(new TextEntry(text));
            return this;
        }

        public Builder sprite(@NotNull class_2960 spriteId, int width, int height) {
            return this.component(new ClientSpriteTooltipComponent(spriteId, width, height));
        }

        public Builder component(@NotNull class_5684 component) {
            this.entries.add(new ComponentEntry(component));
            return this;
        }

        public Builder style(@Nullable class_2960 style) {
            this.style = style;
            return this;
        }

        public TooltipData build() {
            return new TooltipData(Collections.unmodifiableList(this.entries), this.style);
        }
    }

    public record ComponentEntry(@NotNull class_5684 component) implements Entry
    {
        @Override
        @NotNull
        public class_5684 toComponent() {
            return this.component;
        }
    }
}

